#!/bin/sh
#

BASH_BASE_SIZE=0x0000204e
CISCO_AC_TIMESTAMP=0x00000000662008bc
CISCO_AC_OBJNAME=iseposture_install.sh                                                                                                                                                                                                                                           
# BASH_BASE_SIZE=0x00000000 is required for signing
# the comment is after or else the code signing tool will find the comment

csc_vercmp() 
{
    ver_from="${1:?missing from-version}"
    ver_to="${2:?missing to-version}"

    if [ "$ver_from" = "$ver_to" ]; then
        echo same
    else
        ver_min="$(printf '%s\n' "$ver_from" "$ver_to" | sort -V | head -n1)"
        if [ "$ver_min" = "$ver_from" ]; then
            echo older
        else
            echo newer
        fi
    fi
}

AC_INSTPREFIX="/opt/cisco/anyconnect"
AC_ISEPOSTURE_PROFILEDIR="${AC_INSTPREFIX}/iseposture"
AC_ISEPOSTURE_SCRIPTDIR="${AC_ISEPOSTURE_PROFILEDIR}/scripts"

CSC_INSTPREFIX="/opt/cisco/secureclient"
CSC_BINDIR="${CSC_INSTPREFIX}/bin"
CSC_LIBDIR="${CSC_INSTPREFIX}/lib"
CSC_PLUGINDIR="${CSC_BINDIR}/plugins"
CSC_ISEPOSTURE_PROFILEDIR="${CSC_INSTPREFIX}/iseposture"
CSC_ISEPOSTURE_SCRIPTDIR="${CSC_ISEPOSTURE_PROFILEDIR}/scripts"

ISEBINFILES="csc_iseposture csc_iseagentd iseposture_uninstall.sh manifesttool_iseposture"
ISELIBFILES="libacise.so"
ISEPLUGINFILES="libacisectrl.so libaciseshim.so"
ISEPOSTUREMANIFEST="ACManifestISEPosture.xml"
ISEMIGRATIONFILES="ISEPostureCFG.xml ConnectionData.xml DGCacheRecords.xml ISEPreferences.xml"
VPNMANIFEST="${CSC_INSTPREFIX}/ACManifestVPN.xml"

LOGFNAME=`date "+csc-linux64-5.1.3.62-iseposture-%H%M%S%d%m%Y.log"`
CLIENTNAME="Cisco Secure Client - ISE Posture"
CURRENTDIR=`dirname $0 2> /dev/null`

INST_BINDIR="${CURRENTDIR}/bin"
INST_PLUGINDIR="${INST_BINDIR}/plugins"
INST_LIBDIR="${CURRENTDIR}/lib"

ARG_NO_LICENSE=0

if [ "x$1" = "x--no-license" ]; then
    ARG_NO_LICENSE=1
fi

echo "Installing ${CLIENTNAME}..."
echo "Installing ${CLIENTNAME}..." > /tmp/${LOGFNAME}
echo `whoami` "invoked $0 from " `pwd` " at " `date` >> /tmp/${LOGFNAME}

# Check for root privileges
if [ `id | sed -e 's/(.*//'` != "uid=0" ]; then
  echo "Sorry, you need super user privileges to run this script."
  echo "Sorry, you need super user privileges to run this script." >> /tmp/${LOGFNAME}
  exit 1
fi

# ISE Posture requires VPN to be installed. We check the presence of the vpn manifest file to check if it is installed.
if [ ! -f ${VPNMANIFEST} ]; then
    echo "AnyConnect VPN should be installed before ISE Posture installation. Install Cisco Secure Client - AnyConnect VPN to proceed."
    echo "Exiting now."
    echo "AnyConnect VPN should be installed before ISE Posture installation. Install Cisco Secure Client - AnyConnect VPN to proceed." >> /tmp/${LOGFNAME}
    echo "Exiting now." >> /tmp/${LOGFNAME}
    exit 1
fi

failed=false
# version of ise posture being installed has to be same as installed VPN version
if [ -f "${CURRENTDIR}/${ISEPOSTUREMANIFEST}" ] && [ -f ${VPNMANIFEST} ]; then
    VPNVERSION=$(awk -F"\"" '/file version/ { print $2 }' ${VPNMANIFEST})
    ISECURRVERSION=$(awk -F"\"" '/file version/ { print $2 }' ${CURRENTDIR}/${ISEPOSTUREMANIFEST})

    vpn_ver="$(csc_vercmp "$VPNVERSION" "$ISECURRVERSION")"
    if [ "$vpn_ver" != same ]; then
     failed=true
    fi
fi

if [ "$failed" = true ]; then
    echo "Please use ise posture installer from Cisco Secure Client package with version ${VPNVERSION} for the installation"
    echo "Please use ise posture installer from Cisco Secure Client package with version ${VPNVERSION} for the installation" >> /tmp/${LOGFNAME}
    echo "Exiting now."
    echo "Exiting now." >> /tmp/${LOGFNAME}
    exit 1
fi

if [ "x${ARG_NO_LICENSE}" = "x1" ]; then
    echo "Skipping license text ..."
else
    if [ -f "license.txt" ]; then
        cat ./license.txt
        echo
        echo -n "Do you accept the terms in the license agreement? [y/n] "
        read LICENSEAGREEMENT
        while :
        do
          case ${LICENSEAGREEMENT} in
               [Yy][Ee][Ss] | [Yy])
                       echo "You have accepted the license agreement."
                       echo "Please wait while ${CLIENTNAME} is being installed..."
                       break
                       ;;
               [Nn][Oo] | [Nn])
                       echo "The installation was cancelled because you did not accept the license agreement."
                       echo "The installation was cancelled because you did not accept the license agreement." >> /tmp/${LOGFNAME}
                       exit 1
                       ;;
               *)
                       echo "Please enter either \"y\" or \"n\"."
                       read LICENSEAGREEMENT
                       ;;
          esac
        done
    else
        echo "License file not found. Aborting installation."
        echo "License file not found. Aborting installation." >> /tmp/${LOGFNAME}
        exit 1
    fi
fi
if [ -x "/usr/bin/install" ]; then
    INSTALL="/usr/bin/install"
elif [ -x "/bin/install" ]; then
    INSTALL="/bin/install"
elif [ -x "/usr/local/bin/install" ]; then
    INSTALL="/usr/local/bin/install"
else
    INSTALL="install"
fi

${INSTALL} --help 2> /dev/null > /dev/null
if [ $? != 0 ]; then
    INSTALL=""
fi

echo "Creating directories... "
echo "Creating directories... " >> /tmp/${LOGFNAME}

if [ "x${INSTALL}" = "x" ]; then
    echo "Unable to find install command. Aborting installation."
    echo "Unable to find install command. Aborting installation." >> /tmp/${LOGFNAME}
    exit 1
fi

# Make sure destination directories exist
echo "Installing "${CSC_BINDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${CSC_BINDIR} || exit 1
echo "Installing "${CSC_LIBDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${CSC_LIBDIR} || exit 1
echo "Installing "${CSC_PLUGINDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${CSC_PLUGINDIR} || exit 1
echo "Installing "${CSC_ISEPOSTURE_PROFILEDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${CSC_ISEPOSTURE_PROFILEDIR} || exit 1
echo "Installing "${CSC_ISEPOSTURE_SCRIPTDIR} >> /tmp/${LOGFNAME}
${INSTALL} -d ${CSC_ISEPOSTURE_SCRIPTDIR} || exit 1

echo "done."
echo "done." >> /tmp/${LOGFNAME}

# Migrate /opt/cisco/anyconnect/iseposture/ files to /opt/cisco/secureclient/iseposture/
for file in ${ISEMIGRATIONFILES}; do
    if [ -f ${AC_ISEPOSTURE_PROFILEDIR}/$file ] &&
       [ ! -f ${CSC_ISEPOSTURE_PROFILEDIR}/$file ]; then
      echo "Migrating "${AC_ISEPOSTURE_PROFILEDIR}/$file >> /tmp/${LOGFNAME}
      cp -f ${AC_ISEPOSTURE_PROFILEDIR}/$file ${CSC_ISEPOSTURE_PROFILEDIR}/ >/dev/null 2>&1
    fi
done
if [ -d "${AC_ISEPOSTURE_SCRIPTDIR}" ]; then
    echo "Migrating "${AC_ISEPOSTURE_SCRIPTDIR}/ >> /tmp/${LOGFNAME}
    tar cf - -C ${AC_ISEPOSTURE_SCRIPTDIR} . | (cd ${CSC_ISEPOSTURE_SCRIPTDIR}; tar --skip-old-files -x -f -)
fi

echo "Copying files... "
echo "Copying files... " >> /tmp/${LOGFNAME}

for f in ${ISEBINFILES}; do
    echo "Installing "${INST_BINDIR}/$f >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${INST_BINDIR}/$f ${CSC_BINDIR} || exit 1
done

for f in ${ISELIBFILES}; do
    echo "Installing "${INST_LIBDIR}/$f >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${INST_LIBDIR}/$f ${CSC_LIBDIR} || exit 1
done

for f in ${ISEPLUGINFILES}; do
    echo "Installing "${INST_PLUGINDIR}/$f >> /tmp/${LOGFNAME}
    ${INSTALL} -o root -m 755 ${INST_PLUGINDIR}/$f ${CSC_PLUGINDIR} || exit 1
done

echo "done."
echo "done." >> /tmp/${LOGFNAME}

# update manifest
echo "Updating AC manifest." >> /tmp/${LOGFNAME}

${INSTALL} -o root -m 755 ${CURRENTDIR}/${ISEPOSTUREMANIFEST} ${CSC_INSTPREFIX} >> /tmp/${LOGFNAME}
${INST_BINDIR}/manifesttool_iseposture -i ${CSC_INSTPREFIX} ${CSC_INSTPREFIX}/${ISEPOSTUREMANIFEST} >> /tmp/${LOGFNAME}

# enable GUI launch at login
if [ -f "${CSC_BINDIR}/acinstallhelper" ]; then
    echo "Enabling Cisco Secure Client - GUI launch at login." >> /tmp/${LOGFNAME}
    ${CSC_BINDIR}/acinstallhelper -launchAtLogin -enable
fi

echo "done."
echo "done." >> /tmp/${LOGFNAME}

echo "${CLIENTNAME} is installed successfully."
echo "${CLIENTNAME} is installed successfully." >> /tmp/${LOGFNAME}

# move the logfile out of the tmp directory
mv /tmp/${LOGFNAME} ${CSC_INSTPREFIX}/.

exit 0


  +S!cV!j!dqeayIVDMPT!A!kfkjvddSBJJJ!V!eznRGBF r0n0VG4
	c`Ji0
	*H
 0i10	UUS10U
DigiCert, Inc.1A0?U8DigiCert Trusted G4 Code Signing RSA4096 SHA384 2021 CA10
240329000000Z
270404235959Z0v10	UUS10U
Massachusetts10U
Boxborough10U
Cisco Systems, Inc.10UCisco Systems, Inc.0"0
	*H
  0
 ໼OӋ;h;O#~&xRZcH%r%7/?xTȼ*~SN\%ļs\bڟ"|=Lnc<ɕңlߦ͜H?0SXKXZL1Omwisp.,H?U++r`T#'9_џ1>15#=bKw.:@I/nu5-}Q*[HNAIi<u'ˇ?f)._`lo_f
;M9ܡ<]ҍ|ͲLX 66+֓?,Xi1D'tkEF=!c PKw43Hvo[]I̵ Lo9еT_jt$#&GdQ
]FDrUTb-4Af`vYAF.>`WSiޔ 00U#0h7;_a{eNB0Utb=_r3;k*00>U 70503g0)0'+http://www.digicert.com/CPS0U0U%0
+0U00SQOMhttp://crl3.digicert.com/DigiCertTrustedG4CodeSigningRSA4096SHA3842021CA1.crl0SQOMhttp://crl4.digicert.com/DigiCertTrustedG4CodeSigningRSA4096SHA3842021CA1.crl0+00$+0http://ocsp.digicert.com0\+0Phttp://cacerts.digicert.com/DigiCertTrustedG4CodeSigningRSA4096SHA3842021CA1.crt0	U0 0
	*H
  q&~	]梦F7V7ˌyNjzGGE@Gf2_Qc"wU@+򚑙Q߂&k>Q!ෑL8)z0voriFBa9f0\MqoE>Gg޽cOZ咝''lo
<=
Pb$1gnmG?yX PF .ҀP;0̷
+U8Q
usr}x#bAֳ_AЏiʧO8F=]Θu3ar1!6gL^iDlXM.F|tg-xa4ZZ8(4JoiGMv>6ނ4)؜ \Hy&Wq_e;D*2ћ.`mյ0S`L<0,Ѧ]Y1DA6 00@`ҜL^ͩ0
	*H
 0b10	UUS10U
DigiCert Inc10Uwww.digicert.com1!0UDigiCert Trusted Root G40
210429000000Z
360428235959Z0i10	UUS10U
DigiCert, Inc.1A0?U8DigiCert Trusted G4 Code Signing RSA4096 SHA384 2021 CA10"0
	*H
  0
 մ/B(x]9YB3=pŻą&0h\4$KOxCgROẂ>Mp$d}4}LWkC;GZL %Ӌ	eI5=Q!xE.,IpB2ehMLHRhW]eO,HV5. 7|2t9`ֹ1ܭ#GGnmjg-ҽD;	Ǜ2Zj`TI\o&ղ8Αoa4\E(6*f(_s΋&%\Lb^3
+6yue̻HPwPFaX|<(9Է
SGu00v[K]taM?v޿Xr)Am&vhAX&+MYxρJ>@G_ɁPs#!Y`dT!8|fx8E0OcOL
SA|X=G2	l<V Y0U0U0 0Uh7;_a{eNB0U#0q]dL.g?纘O0U0U%0
+0w+k0i0$+0http://ocsp.digicert.com0A+05http://cacerts.digicert.com/DigiCertTrustedRootG4.crt0CU<0:08642http://crl3.digicert.com/DigiCertTrustedRootG4.crl0U 00g0g0
	*H
  :#D=v:VH4,tfr ʯl0'DK|&7:]Hm?I'EPv~7q"Zj PyH~؀aVv_C>v9=ԙJ(_&XH'?v`\
98Nn6!SZj>C3O8Tm]@3|╲!usRF4Kov7,?&C p)5\8U7	1.\9qᾜ
&gN_zI.t<V+#{pk栺:?ERAHKMD@(V*/d<3(<ˏ
;{˷w(?/"lA\flņ&3Kjj@0HK4Q Y
mP+JtRH!W;Eanh&`ȯc:VxN  no6.x9azbd>B
!*W
,t=!K3>mJD
G{&Y6X(=W/B6;i&!D?m0v"N
S-EqOUs! >i(%ЌePalfVc~
LFk F\ȰAmAx}&zWکK7ںK<J1̰ci{vwIB6U0_UuϩɹERʤ;XpGld~]|c7gaB?*>x"p
mC	*,<>Q
 C#/`;l8a 4GgYY\Zyj-%ZèQc!>?)W;˾ƶs~,[n9ZWJ/cI())V2	L~΋Oڍx<FIЁh]W9mIp	k  $E	ևiq{ۅwڛ"\oSZ+/z-9~X Ke8u*kUvaiͳIoWXUaI8+|ݕ+5ޢ4UMVw&t/ѓ]Y8Waduuƕ/[#omكO- u虩r$ V$kf
;+/sU!TXrK&,)<N5OǼ,
 "63-?)h !
i(݀wDsT?-9Oۖ#öa5!:
Y$
dwow0\%iDzl;WF-! ~7'9. LY]8+c8)
xk 芦>/vh
X1FĂÚ"]|D($@ GǐlQ޶pzt.thYj}:h']X"15[K0r